use super::{Point, calcul_dimensions, voie_vers_segments, voies_vers_segments};

pub fn svg_chemin(chemin: &[Point]) -> String {
    //TODO: flip y
    let [xmin, ymin, xmax, ymax] = calcul_dimensions(chemin);
    let largeur = xmax - xmin;
    let hauteur = ymax - ymin;
    let entete = format!(
        "<svg width='800' height='600' viewBox='{} {} {} {}'><g translate='(0,{})'><g stroke-width='1%' stroke='red' transform='scale(1,-1)'>",
        xmin, ymin, largeur, hauteur, hauteur
    );
    let corps = voie_vers_segments(chemin)
        .map(|s| s.svg())
        .collect::<String>();
    let pied = "</g></g></svg>";
    entete + &corps + pied
}

pub fn svg_carte_et_chemin(chemin: &[Point], carte: &[Vec<Point>]) -> String {
    let quadrant = calcul_dimensions(chemin);
    let [xmin, ymin, xmax, ymax] = quadrant;
    let largeur = xmax - xmin;
    let hauteur = ymax - ymin;
    let entete = format!(
        "<svg width='800' height='600' viewBox='{} {} {} {}'><g stroke-width='1%' stroke='red'>",
        xmin, ymin, largeur, hauteur
    );
    let svg_chemin = format!(
        "<g stroke='red'>{}</g>",
        voie_vers_segments(chemin)
            .map(|s| s.svg())
            .collect::<String>()
    );
    let svg_carte = format!(
        "<g stroke='blue'>{}</g>",
        voies_vers_segments(carte)
            .map(|s| s.svg())
            .collect::<String>()
    );
    let pied = "</g></svg>";
    entete + &svg_carte + &svg_chemin + pied
}
