use super::Point;
use xml::attribute::OwnedAttribute;

use gpx::{Gpx, read};
use std::{fs::File, io::BufReader, path::Path};

pub fn lecture_chemin<P: AsRef<Path>>(nom_fichier: P) -> std::io::Result<Vec<Point>> {
    let fichier_gpx = BufReader::new(File::open(nom_fichier)?);

    let gpx: Gpx = read(fichier_gpx)
        .map_err(|e| std::io::Error::new(std::io::ErrorKind::InvalidData, e.to_string()))?;

    todo!("lisez le premier track et convertissez le en vecteur de points");
}

fn lecture_attribut<A: std::str::FromStr>(attributs: &[OwnedAttribute], clef: &str) -> Option<A> {
    for attribut in attributs {
        if attribut.name.local_name == clef {
            return attribut.value.parse::<A>().ok();
        }
    }
    None
}
