use geo_types::Point;
use itertools::Itertools; // si besoin

pub struct Segment {
    debut: Point,
    fin: Point,
}

impl Segment {
    fn new(p1: Point, p2: Point) -> Self {
        Segment { debut: p1, fin: p2 }
    }
    fn delta(&self) -> [f64; 2] {
        [self.fin.x() - self.debut.x(), self.fin.y() - self.debut.y()]
    }
    fn longueur(&self) -> f64 {
        self.longueur_carree().sqrt()
    }
    fn longueur_carree(&self) -> f64 {
        let [diff_x, diff_y] = self.delta();
        diff_x * diff_x + diff_y * diff_y
    }
    fn distance_au_point(&self, p: &Point) -> f64 {
        let debut_vers_point = Segment::new(self.debut, *p);
        let l2 = self.longueur_carree();
        if l2 <= f64::EPSILON {
            return debut_vers_point.longueur();
        }
        // si on note d le debut du segment et f la fin
        // la ligne du segment a l'equation d + t (f - d).
        // pour trouver la projection de p sur la ligne
        // on a t = [(p-d) . (f-d)] / |f-d|^2
        // t est garde entre [0,1] pour rester dans le segment.
        let [x0, y0] = debut_vers_point.delta();
        let [x1, y1] = self.delta();
        let dot = x0 * x1 + y0 * y1;
        let t = (dot / l2).clamp(0.0, 1.0);

        let proj = Point::new(self.debut.x() + x1 * t, self.debut.y() + y1 * t);
        Segment::new(*p, proj).longueur()
    }
}

fn polygone(nombre_cotes: u32) -> Vec<Point> {
    todo!()
}

fn svg_chemin(chemin: &[Point]) -> String {
    todo!()
}

mod parseurs;
mod simplification;

fn main() -> std::io::Result<()> {
    let poly = polygone(3);
    println!("{}", svg_chemin(&poly));
    Ok(())
}
