## Envol 2025 : GPX et OSM

Dans ce petit TP on se propose de programmer un visualiseur Svg de traces GPX
(couramment utilisées en cyclisme et en randonnées) sur une carte récupérée
sur OpenStreetMap.

On démarre doucement et on complexifiera graduellement les choses.

Le dossier 'gps' contient le code à compléter et le dossier 'correction_gps' la correction.

### Échauffement

Pour commencer, vous pouvez simplement exécuter le code fourni.
Placez vous dans le dossier *gps* puis tapez

```bash
cargo run
```

dans le terminal. Une autre possibilité est de compiler avec des optimisations
plus agressives en mode *release* à l'aide de

```bash
cargo run --release
```

La compilation est alors plus lente, on perd les symboles de debug et certaines assertions.
Néanmoins il sera nécessaire de compiler en *release* pour effectuer des tests de performance.

Dans ce projet on va manipuler des coordonnées géographiques stockées sous forme de *Point*
dans le plan. On utilise une classe *Point* toute faite, fournie par la bibliothèque
*geo_types*. La documentation de cette classe est accessible [sur docs.rs](https://docs.rs/geo-types/latest/geo_types/geometry/struct.Point.html).

Pour s'échauffer un peu, on vous demande de compléter la fonction *polygone* prenant en argument
un entier $n$ et renvoyant un vecteur de $n$ points contenant un polygone régulier inscrit
dans le cercle unité. Vous devez donc utiliser des [vecteurs](https://doc.rust-lang.org/stable/std/vec/struct.Vec.html)
et un peu de trigonométrie avec les **méthodes** *cos* et *sin* sur les flottants.
La constante PI est accessible en tant que *std::f64::consts::PI*.

On enchaine tout de suite avec un peu de *svg*.
Le but est d'afficher graphiquement un chemin stocké dans une tranche de *Point*.
On part du premier point et on avance jusqu'au dernier.
Écrivez une fonction de conversion convertissant une tranche sur des points en
vecteur de *Segment* (en reliant chaque point à son suivant).
Une tranche de $n$ points donnera donc un vecteur de $n-1$ segments.
Enfin, ajoutez une méthode *svg* sur la classe *Segment* renvoyant un *String* contenant
le code svg du segment. On utilisera une balise *line* comme par exemple:

```svg
<line x1='3.4' y1='2.5' x2='-1.4' y2='2.2'/>
```

Il est assez facile de construire des *String* personnalisés avec la macro [format](https://doc.rust-lang.org/stable/std/macro.format.html).

Dernière étape, il nous manque l'entête et le pied de l'image.
On cherche à obtenir un code svg comme celui-ci (obtenu pour le chemin du triangle) :

```svg
<svg width='800' height='600' viewBox='-0.5000000000000004 -0.8660254037844384 1.5000000000000004 1.7320508075688772' xmlns='http://www.w3.org/2000/svg'>
  <g stroke-width='1%' stroke='red'>
    <line x1='1' y1='0' x2='-0.4999999999999998' y2='0.8660254037844387'/>
    <line x1='-0.4999999999999998' y1='0.8660254037844387' x2='-0.5000000000000004' y2='-0.8660254037844384'/>
  </g>
</svg>
```

On utilise une *viewBox* dans l'entête pour préciser l'espace des coordonnées à afficher.
Celle-ci à quatre paramètres : le $x$ minimal, le $y$ minimal, la largeur et la hauteur.
Il est donc nécessaire de scanner tous les points pour calculer les dimensions de l'espace en plus de générer le code
svg de tous les segments.
Le groupe (situé après l'entête) est là pour préciser la couleur et l'épaisseur utilisée pour les lignes.

Complétez la fonction *svg_chemin* prenant une tranche de *Point* et renvoyant un *String* :
le code svg de l'image dessinant le chemin.
Vous pouvez ensuite tester sur différents polygones (à l'aide d'un *println* et d'une petite redirection).


### GPX

Dans le fichier *src/parseurs.rs* complétez la fonction *lecture_chemin*.
La fonction [read](https://docs.rs/gpx/latest/gpx/fn.read.html) de la bibliothèque *gpx* donne un accès
au contenu du fichier. Il reste a extraire les points de tous les segments du premier track.

Vous pouvez ensuite afficher le chemin en svg du fichier *tour_ensimag.gpx* à l'aide de *svg_chemin*.


### Simplification gloutonne

Ok, on va maintenant simplifier le chemin, tout en conservant sa forme approximative.
L'idée est la suivante : supposons que l'on remplace l'entièreté du chemin par un seul segment entre 
le premier et le dernier point que l'on appellera le *raccourci*. Pour savoir si cette approximation
est suffisamment précise, on parcourt tous les points du chemin et on calcule leurs distances au raccourci
(il y a une méthode pour ça dans la classe *Segment*).
Si toutes ces distances sont très petites (inférieures à un seuil donné) alors l'approximation est acceptable.


Bien entendu, au départ le raccourci est trop grossier. Pour résoudre le problème on va faire du *diviser pour régner*.
On cherche le point le plus éloigné du raccourci que l'on appellera le point de passage. On décide de ne pas l'éliminer.
Si on prend la tranche initiale contenant tous les points du chemin, on peut s'en servir pour construire deux tranches: 
celle contenant tous les points du départ jusqu'au point de passage (inclus) et celle contenant tous les points
du point de passage (inclus) jusqu'à la fin. Deux appels récursifs nous donnent alors les points à garder
pour les deux parties du chemin. On concatènera les deux résultats (en évitant de prendre le point de passage en double).

Complétez les fonctions *indice_et_distance_point_interne_plus_eloigne* et *simplification_gloutonne* 
du fichier *src/simplification.rs*.

Vous pouvez tester votre algorithme de simplification pour un seuil de 0.00005.


### Simplification par programmation dynamique

On va maintenant réaliser une programmation dynamique pour obtenir une meilleure simplification.
En effet, rien ne garantit que le choix du point le plus éloigné soit le meilleur choix possible du point de passage.
On se propose donc d'écrire une fonction récursive *choix_points* prenant l'ensemble des points, le seuil,
deux indices : l'indice $i$ du premier et l'indice $j$ du dernier point considérés et le cache : une table de hachage
pour la mémoïsation. Cette fonction renvoie le nombre de points du chemin optimal entre les ième et jème points et stocke dans
la table de hachage pour la clef $(i,j)$ l'indice du point de passage et le nombre de points du chemin optimal.

Pour calculer ces résultats il y a quatre options :

- soit le cache contient déjà un résultat pour $(i,j)$ auquel il suffit de le renvoyer
- soit $j-i <= 2$ : il n'y a plus de point de passage possible
- soit tous les points entre $i$ et $j$ sont proches du raccourci entre le ième et le jème point auquel cas 
aucun point de passage n'est nécessaire (et le nombre de points optimal vaut 2)
- sinon, on fait deux appels récursif pour **chaque** point de passage possible : pour chaque indice $p$ avec $i < p < j$.
Pour chaque $p$ on récupère une longueur de chemin depuis le départ jusqu'à $p$ et une autre depuis $p$ jusqu'à l'arrivée.
On les somme, on retranche 1 pour ne pas compter $p$ en double et on obtient la longueur du chemin optimal entre $i$ et $j$ en prenant $p$ comme
point de passage. On sélectionne le $p$ qui minimise cette longueur.


L'appel au *choix* pour i = 0 et j = dernier indice permet de calculer la longueur optimale pour tout le chemin.
Ce calcul va au passage remplir la table de hachage avec les choix du point de passage à réaliser pour chaque
intervalle. Pour trouver quels sont les points à garder il nous faut une seconde fonction récursive
*calcul_points_a_garder* qui lit dans la table le point de passage pour un intervalle et récurse sur les deux sous-intervalles
correspondants.

Une fois ces deux fonctions écrites vous pouvez alors compléter la fonction *simplification_chemin*.

Vous pouvez la tester, chez moi elle met une trentaine de secondes à s'exécuter mais fournit
un meilleur résultat que la simplification gloutonne.


### Simplifications hybrides et parallèles


L'optimisation suivante consiste à gagner sur tous les tableaux : profiter de la vitesse
de l'algorithme glouton et de la qualité de la programmation dynamique.

Pour faire ça, on écrite une fonction *simplification_hybride* qui fonctionne de la manière suivante :

- si le nombre de points de la tranche *chemin* est < 500 alors on utilise la programmation dynamique
- sinon, on sélectionne le point de passage le plus éloigné (comme dans l'algorithme glouton) et on récurse
(en hydride) sur les deux parties du chemin.


On obtient alors un algorithme très rapide et avec d'excellents résultats.

Dernière étape : on peut paralléliser les appels récursifs de l'hybride à l'aide de *rayon*.

Il nous suffit de passer les deux appels dans [join](https://docs.rs/rayon/latest/rayon/fn.join.html)

Vous pouvez utiliser *std::time::Instant* pour faire différentes mesures de performances.


### OSM

Il me parait difficile d'arriver jusqu'ici en trois heures. Mais si jamais vous êtes très fort (ou que vous avez déjà fait un peu de rust) c'est possible.
Je vous ai mis un fichier "interpreter" qui contient le résultat d'une requête à OpenStreetMap demandant les voies empruntables dans la région de mon chemin.
C'est un fichier *xml* que l'on peut parser avec la crate *xml* assez facilement.

Trois types de balises nous intéressent. Les *noeuds* (node) correspondent à des points sur la carte. Chaque noeud a un identifiant unique, une latitude et 
une longitude. Seconde balise les *voies* (way). Chaque voie est un petit chemin composé de plusieurs noeuds. Ceux-ci sont désignés par référence à l'aide
de leurs identifiants uniques et d'une troisième balise *nd*.

Pour parser le xml on utilisera une boucle sur un lecteur d'évènements (xml::EventReader).
On regardera les évènements de début et de fin pour les trois balises qui nous intéressent. Les informations additionnelles seront 
récupérées dans les attributs des éléments.

Il sera nécessaire de stocker les noeuds rencontrés dans une table de hachage et on renverra un vecteur contenant toutes les voies,
chaque voie étant elle-même un vecteur de *Point*.

Une fois les voies récupérées vous pouvez terminer le projet en ajoutant une fonction d'affichage pour visualiser la trace gpx
sur la carte.

